jQuery(document).ready(function () {

    let updatedCartTotal = '';

    function updateCartTotal() {
        let cartContainer = jQuery('.payment_method_paythen .cart-total, #radio-control-wc-payment-method-options-paythen__content .cart-total');
        let minUpfrontAmountContainer = jQuery('#minimum-upfront-amount'); // Check if the message container already exists
        if (!cartContainer.length) {
            console.log("Paythen cart total container not found.");
            return;
        }

        let cartCurrency = cartContainer.attr("data-currency") || '$';
        let cartRdays = cartContainer.attr("data-rdays") || '';

        let cartTotal = parseFloat(cartContainer.attr("data-total")) || 0;
        let customerInstalment = parseFloat(jQuery('#customer_instalment').val()) || 0;
        let customerUpfront = parseFloat(jQuery('#customer_upfront').val()) || 0;

        let minUpfrontAmount = parseFloat(jQuery('#customer_upfront').attr('min')) || 0;
        let existingMessage = jQuery('#minimum-upfront-amount');

        if (minUpfrontAmount > 0) {
            let messageText = `Minimum amount required: $${minUpfrontAmount.toFixed(2)}`;

            // If message doesn't exist, add it. Otherwise, update it.
            if (existingMessage.length === 0) {
                jQuery('#customer_upfront').after(`<p class="minimum-text" id="minimum-upfront-amount">${messageText}</p>`);
            } else {
                existingMessage.text(messageText);
            }
        } else {
            existingMessage.remove(); // Remove the message if no minimum required
        }

        if (isNaN(cartTotal) || isNaN(customerInstalment) || customerInstalment === 0) {
            cartContainer.html('');
            jQuery('.refresh-cart-total').hide();
        } else {
            customerUpfront = Math.min(customerUpfront, cartTotal);
            let remainingAmount = cartTotal - customerUpfront;
            let totalAmount = remainingAmount / customerInstalment;

            function customRound(value) {
                return Math.round(value * 100) / 100; // Round to 2 decimal places
            }

            totalAmount = customRound(totalAmount);
            let formattedTotalAmount = totalAmount.toLocaleString(undefined, {
                minimumFractionDigits: 2,
                maximumFractionDigits: 2
            });

            let paymentMessage = `${customerInstalment} payments of ${cartCurrency}${formattedTotalAmount} each`;
            if (cartRdays) {
                paymentMessage += ` starting in ${cartRdays} days`;
            }

            cartContainer.html(paymentMessage);
            jQuery('.refresh-cart-total').show();
        }
    }

    function bindInputEvents() {
        jQuery('#customer_upfront, #customer_instalment').off('keyup change').on('keyup change', function () {
            updateCartTotal();
        });
    }

    function checkAndInit() {
        if (jQuery('#customer_upfront').length && jQuery('#customer_instalment').length) {
            updateCartTotal();
            bindInputEvents();
        } else {
            setTimeout(checkAndInit, 500); // Retry every 500ms until elements are found
        }
    }

    // Ensure script runs after WooCommerce Blocks are fully loaded
    setTimeout(checkAndInit, 500);

    // Classic Checkout Hook
    jQuery(document).on('updated_checkout', function () {
        updateCartTotal();
        bindInputEvents();
    });

    // WooCommerce Blocks: Observe for changes
    if (window.wc && window.wc.blocksRegistry) {
        const observer = new MutationObserver(function (mutationsList) {
            mutationsList.forEach((mutation) => {
                if (mutation.type === 'childList' || mutation.type === 'subtree') {
                    updateCartTotal();
                    bindInputEvents();
                }
            });
        });

        observer.observe(document.body, {
            childList: true,
            subtree: true,
        });
    }

    jQuery(document).on('change', 'input[name="radio-control-wc-payment-method-options"]', function() {
        if (jQuery(this).val() === 'paythen') {
            updateCartTotal();
            bindInputEvents();
        }
    });

    jQuery('form.checkout').on('change', 'input[name="payment_method"]', function(){
        jQuery(document.body).trigger('update_checkout');
        updateCartTotal();
        bindInputEvents();
    });

    jQuery('.paythen-modal').click(function(){
        jQuery('#paythen-product-detail').show(400);
    });
    jQuery('.product-detail-data span.close').click(function(){
        jQuery('#paythen-product-detail').hide(400);
    });
});

jQuery(document).ready(function(){
    // Also listen manually for any click on payment method options (backup)
    /* jQuery(document).on('keyup mouseup change', '#customer_instalment', function() {
        let cartCurrency = jQuery('.payment_method_paythen .cart-total').attr("data-currency");
        jQuery('.shop_table').find('.order-total .woocommerce-Price-amount').each(function(){
            updatedCartTotal = jQuery(this).text();
        });
        updatedCartTotal = updatedCartTotal.replace(cartCurrency,'');
        updatedCartTotal = updatedCartTotal.replace(/,/g, '');
        jQuery('.payment_method_paythen .cart-total').attr('data-total', updatedCartTotal);

        let cartTotal = jQuery('.payment_method_paythen .cart-total').attr("data-total");
        let customerInstalment =  jQuery(this).val();
        let totalAmount = Math.round(cartTotal / customerInstalment);
        if (customerInstalment === ''){ jQuery('.payment_method_paythen .cart-total').html(''); jQuery('.refresh-cart-total').hide(); }
        else{ 
            jQuery('.payment_method_paythen .cart-total').html(`${customerInstalment} payments of ${cartCurrency}${totalAmount} each`); 
            jQuery('.refresh-cart-total').show();
        }
    }); */
});