<?php
if( ! defined('ABSPATH') ) die('Not Allowed');


/**
 * Custom function to declare compatibility with cart_checkout_blocks feature 
*/
/* semal note hide this for fix debug log issue
function paythen_declare_cart_checkout_blocks_compatibility() {
    // Check if the required class exists
    if (class_exists('\Automattic\WooCommerce\Utilities\FeaturesUtil')) {
        // Declare compatibility for 'cart_checkout_blocks'
        \Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility('cart_checkout_blocks', __FILE__, true);
    }
}*/

function paythen_declare_cart_checkout_blocks_compatibility() {
    if ( class_exists( '\Automattic\WooCommerce\Utilities\FeaturesUtil' ) ) {
        $main_plugin_file = WP_PLUGIN_DIR . '/paythen-payment-plans-for-wooCommerce/paythen-payment-plans-for-wooCommerce.php';
        \Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility('cart_checkout_blocks',$main_plugin_file,true);
    }
}

// Hook the custom function to the 'before_woocommerce_init' action
add_action('before_woocommerce_init', 'paythen_declare_cart_checkout_blocks_compatibility');

// Hook the custom function to the 'woocommerce_blocks_loaded' action
add_action( 'woocommerce_blocks_loaded', 'paythen_register_order_approval_payment_method_type' );

/**
 * Custom function to register a payment method type
 */
function paythen_register_order_approval_payment_method_type() {
    // Check if the required class exists
    if ( ! class_exists( 'Automattic\WooCommerce\Blocks\Payments\Integrations\AbstractPaymentMethodType' ) ) {
        return;
    }

    // Include the custom Blocks Checkout class
    require_once plugin_dir_path(__FILE__) . 'class-block.php';

    // Hook the registration function to the 'woocommerce_blocks_payment_method_type_registration' action
    add_action(
        'woocommerce_blocks_payment_method_type_registration',
        function( Automattic\WooCommerce\Blocks\Payments\PaymentMethodRegistry $payment_method_registry ) {
            // Register an instance of Paythen_Custom_Gateway_Blocks
            $payment_method_registry->register( new Paythen_Custom_Gateway_Blocks() );
        }
    );
}

add_filter('woocommerce_payment_gateways', 'add_paythen_gateway');
add_filter('woocommerce_available_payment_gateways', 'remove_paythen_if');

function add_paythen_gateway($methods) {
    $methods[] = 'WC_Gateway_Paythen';
    return $methods;
}

function remove_paythen_if($gateways) {
  // no cart to check in admin
  if (is_admin()) return $gateways;

  if ( ! is_cart() && ! is_checkout() ) {
    return $gateways;
  }
  $hasDisabled = false;

  $gateway = WC_Gateway_Paythen::instance();
  if($gateway->get_option('product_paythen_payment') == 'yes') {
    // check for products in the cart with Paythen disabled
    foreach (WC()->cart->get_cart() as $cart_item_key => $item) {
      if (get_post_meta( $item['product_id'], 'paythen_enable', true ) == 'yes') {
        $hasDisabled = false;
      }else{ $hasDisabled = true; }
    }
  }

    $currency = get_woocommerce_currency();
    //var_dump($currency);

    // WooCommerce zero-decimal currencies
    $zero_decimal_currencies = apply_filters('woocommerce_zero_decimal_currencies', [
        'BIF', 'CLP', 'DJF', 'GNF', 'JPY', 'KMF', 'KRW', 'MGA', 'PYG', 'RWF', 'UGX', 'VND', 'VUV', 'XAF', 'XOF', 'XPF'
    ]);

    // Check if the currency is zero-decimal
    $currency = trim($currency);
    if (in_array($currency, $zero_decimal_currencies)) {
        $hasDisabled = true;
    }

  $cartTotal = WC()->cart->get_total(null);

  $globalMin = $gateway->get_option('min_amount');
  $globalMinOne = $gateway->get_option('min_amount_one');

  // check for a global Paythen max
  $globalMax = $gateway->get_option('max_amount');
  $globalMaxOne = $gateway->get_option('max_amount_one');

  if ( ! empty($globalMin) && $globalMin > 0 && $cartTotal < $globalMin) $hasDisabled = true;  

  if(!empty($globalMaxOne) && $globalMaxOne > 0 && $cartTotal > $globalMaxOne) $hasDisabled = true;

  if ($hasDisabled){ unset($gateways['paythen']); }
   
  return $gateways;
}

add_action('woocommerce_checkout_process', 'process_paythen_custom_checkout_field');
function process_paythen_custom_checkout_field() {
    $cartTotal = WC()->cart->get_total(null);
    $selected_payment_method_id = WC()->session->get( 'chosen_payment_method' );
    $selected_payment_method = WC()->payment_gateways()->payment_gateways()[ $selected_payment_method_id ];
    
    if($selected_payment_method_id === 'paythen'){

      $gateway = WC_Gateway_Paythen::instance();
      $customerVlaue  = $_POST['customer_instalment'];
      $items = WC()->cart->get_cart();
      $subscriptionValue = 1;
      foreach ($items as $item => $values)
      {
        $product_type = $values['data']->get_type();
        if (str_contains($product_type, 'subscription')) { 
          $subscriptionValue = 0;
        }
      }

        if( ($gateway->get_option('number-installments') == 'yes') && ($subscriptionValue === 1) && ($cartTotal != 0)){
            if($gateway->get_option('min_installment')){
              $minimumInstallment = $gateway->get_option('min_installment');
            }
            if($gateway->get_option('max_installment')){
              $maximumInstallment = $gateway->get_option('max_installment');
            }

            if($customerVlaue == "") {
              wc_add_notice( __( 'Please enter number more then '.$minimumInstallment.' for the number of payments.' ), 'error' );
            } else {
              if($maximumInstallment == "")
              {
                if($customerVlaue < $minimumInstallment){
                  wc_add_notice( __( 'Please enter number more then '.$minimumInstallment.' payments for the payment plan.' ), 'error' );
                }
              }
              else {
                if($customerVlaue < $minimumInstallment){
                  wc_add_notice( __( 'Please choose between '.$minimumInstallment.' and '.$maximumInstallment.' payments for the payment plan.' ), 'error' );
                }
                else if( $customerVlaue > $maximumInstallment){
                  wc_add_notice( __( 'Please choose between '.$minimumInstallment.' and '.$maximumInstallment.' payments for the payment plan.' ), 'error' );
                }
              }
            }
        }

        if (($gateway->get_option('upfront-payment-amount-option') == 'yes') && ($subscriptionValue === 1) && ($cartTotal != 0)) {
            $amount_upfront_type = $gateway->get_option('amount_upfront_type'); // 'fixed' or 'percentage'
            $min_upfront_value = $gateway->get_option('min_amount_one_upfront'); // Can be empty
            $max_upfront_value = $gateway->get_option('max_amount_one_upfront'); // Can be fixed or percentage

            $min_upfront_amount = null;
            $max_upfront_amount = null;

            // Calculate the minimum upfront amount if it's set
            if (!empty($min_upfront_value)) {
                if ($amount_upfront_type === 'fixed') {
                    $min_upfront_amount = (int) $min_upfront_value;
                } elseif ($amount_upfront_type === 'percentage') {
                    $min_upfront_amount = ceil(($cartTotal * (int) $min_upfront_value) / 100);
                }
                // Ensure minimum upfront is not below the minimum installment
                $min_upfront_amount = max($minimumInstallment, $min_upfront_amount);
            }

            // Calculate the maximum upfront amount if it's set
            if (!empty($max_upfront_value)) {
                if ($amount_upfront_type === 'fixed') {
                    $max_upfront_amount = (int) $max_upfront_value;
                } elseif ($amount_upfront_type === 'percentage') {
                    $max_upfront_amount = ceil(($cartTotal * (int) $max_upfront_value) / 100);
                }

                // Ensure max upfront does not exceed cart total
                $max_upfront_amount = min($max_upfront_amount, $cartTotal);
            } else {
                $max_upfront_amount = $cartTotal; // Default to cart total if no max limit is set
            }

            $min_upfront_display = ($min_upfront_amount !== null) ? wc_price($min_upfront_amount) : '';
            $max_upfront_display = ($max_upfront_amount !== null) ? wc_price($max_upfront_amount) : '';
            $customer_upfront = $_POST['customer_upfront'];

            // Validate user input
            if(!empty($min_upfront_value) || !empty($max_upfront_value)){
                if (!isset($_POST['customer_upfront']) || trim($_POST['customer_upfront']) === '' || (float)$_POST['customer_upfront'] <= 0) {
                    wc_add_notice(sprintf(__('Please enter an upfront amount.', 'woocommerce'), get_woocommerce_currency_symbol()), 'error');
                } else {
                    if ($min_upfront_amount !== null && $customer_upfront < $min_upfront_amount) {
                        wc_add_notice(sprintf(__('The minimum upfront amount must be at least %s.', 'woocommerce'), wc_price($min_upfront_amount)), 'error');
                    }
                    if ($customer_upfront > $max_upfront_amount) {
                        wc_add_notice(sprintf(__('The maximum upfront amount cannot exceed %s.', 'woocommerce'), wc_price($max_upfront_amount)), 'error');
                    }
                }
            }
        }
    }// end main if
}// end function

add_action('woocommerce_store_api_checkout_update_order_from_request', 'process_paythen_custom_checkout_blocks_field', 10, 2); // Blocks Checkout
function process_paythen_custom_checkout_blocks_field($order = null, $request = null) {
    $is_blocks_checkout = !is_null($request); // Detect if it's Blocks Checkout

    // Retrieve checkout data
    $is_blocks_checkout = !is_null($request); // Detect if it's Blocks Checkout
    $body_params = $is_blocks_checkout ? $request->get_json_params() : $_POST; // Get data from request or POST
    $selected_payment_method_id = $body_params['payment_method'] ?? WC()->session->get('chosen_payment_method');

    // Ensure it's a Paythen payment
    if ($selected_payment_method_id !== 'paythen') {
        return;
    }

    $order_id = null;
    if (!empty($_GET['key'])) {  
        // Normal WooCommerce Flow (Using Order Key)
        $order_id = wc_get_order_id_by_order_key($_GET['key']);
    } elseif (WC()->session->get('order_id')) {  
        // FunnelKit / CartFlows Flow (Using WC Session)
        $order_id = WC()->session->get('order_id');
    }

    if (!$order_id) {
        error_log('Order ID not found');
        return;
    }

    $orderDetail = wc_get_order($order_id);
    if (!$orderDetail) {
        error_log('Order not found for ID: ' . $order_id);
        return;
    }

    // Retrieve values from order meta
    $customer_instalment = $orderDetail->get_meta('_customer_instalment');
    $customer_upfront = $orderDetail->get_meta('_customer_upfront');


    $gateway = WC_Gateway_Paythen::instance();
    $cartTotal = WC()->cart->get_total(null);

    // Detect if the cart contains a subscription product
    $subscriptionValue = 1;
    foreach (WC()->cart->get_cart() as $values) {
        if (str_contains($values['data']->get_type(), 'subscription')) { 
            $subscriptionValue = 0;
            break;
        }
    }

    // Validation function to handle both Classic & Blocks checkout
    function add_checkout_error($message, $is_blocks_checkout) {
        if ($is_blocks_checkout) {
            throw new WC_REST_Exception('woocommerce_rest_checkout_error', $message, 400);
        } else {
            wc_add_notice($message, 'error');
        }
    }

    // Validate Installment Number
    if (($gateway->get_option('number-installments') == 'yes') && ($subscriptionValue === 1) && ($cartTotal != 0)) {
        $minimumInstallment = $gateway->get_option('min_installment') ?: 1;
        $maximumInstallment = $gateway->get_option('max_installment') ?: null;

        if (empty($customer_instalment)) {
            add_checkout_error(__('Please enter a number greater than ' . $minimumInstallment . ' for the number of payments.', 'woocommerce'), $is_blocks_checkout);
        } else {
            $customer_instalment = (int)$customer_instalment;
            if ($customer_instalment < $minimumInstallment || ($maximumInstallment && $customer_instalment > $maximumInstallment)) {
                add_checkout_error(__('Please choose between ' . $minimumInstallment . ' and ' . $maximumInstallment . ' payments for the payment plan.', 'woocommerce'), $is_blocks_checkout);
            }
        }
    }
    
    // Validate Upfront Payment
    if (($gateway->get_option('upfront-payment-amount-option') == 'yes') && ($cartTotal != 0)) {
        $amount_upfront_type = $gateway->get_option('amount_upfront_type'); // 'fixed' or 'percentage'
        $min_upfront_value = $gateway->get_option('min_amount_one_upfront');
        $max_upfront_value = $gateway->get_option('max_amount_one_upfront');

        // Calculate min and max upfront values
        if (!empty($min_upfront_value)) {
            $min_upfront_amount = ($amount_upfront_type === 'fixed') 
                ? floatval($min_upfront_value) 
                : ceil(($cartTotal * floatval($min_upfront_value)) / 100);
        } else {
            $min_upfront_amount = null;
        }

        // Calculate max upfront amount
        if (!empty($max_upfront_value)) {
            $max_upfront_amount = ($amount_upfront_type === 'fixed') 
                ? floatval($max_upfront_value) 
                : ceil(($cartTotal * floatval($max_upfront_value)) / 100);
        } else {
            $max_upfront_amount = floatval($cartTotal); // Default max upfront amount is full cart total
        }

        if(!empty($min_upfront_value) || !empty($max_upfront_value)){
            if ($customer_upfront === '' || (float)$customer_upfront <= 0) {
                add_checkout_error(__('The minimum upfront amount must be at least ' . wc_price($min_upfront_amount) . '.', 'woocommerce'), $is_blocks_checkout);
            } else {
                $customer_upfront = (float) $customer_upfront;
                if ($min_upfront_amount && $customer_upfront < $min_upfront_amount) {
                    add_checkout_error(__('The minimum upfront amount must be at least ' . wc_price($min_upfront_amount) . '.', 'woocommerce'), $is_blocks_checkout);
                }
                if ($customer_upfront > $max_upfront_amount) {
                    add_checkout_error(__('The maximum upfront amount cannot exceed ' . wc_price($max_upfront_amount) . '.', 'woocommerce'), $is_blocks_checkout);
                }
            }
        }
    }
}


// Redirect logic
add_action('template_redirect', function() {
    if (empty($_GET['key'])) {
        return;
    }

    $order_id = wc_get_order_id_by_order_key( $_GET['key'] );
    if ( ! $order_id ) {
        return;
    }

    $order = wc_get_order( $order_id );
    if ( ! $order ) {
        return;
    }


    //$order = wc_get_order( $order_id );
    $order_key = $order->get_order_key();
    $order_number = $order->get_order_number();

    if ('paythen' === $order->get_payment_method()) {
        $gateway = WC_Gateway_Paythen::instance();

        $globalMaxOne = $gateway->get_option('max_amount_one');
        $globalMinOne = $gateway->get_option('min_amount_one');
        $globalMax = $gateway->get_option('max_amount');
        $globalMin = $gateway->get_option('min_amount');

        $customer_fname = $order->get_billing_first_name();
        $customer_lname = $order->get_billing_last_name();
        $customer_email = $order->get_billing_email();

        $numberInstallments = $gateway->get_option('number-installments');
        $separatePayment = $gateway->get_option('separate-payment-option');
        $customerUpfront = $gateway->get_option('upfront-payment-amount-option');
        $upfrontFeetype = $gateway->get_option('amount_upfront_type');
        $rdays = $gateway->get_option('remaining_payment_days_upfront');
        $upfrontLabel = $gateway->get_option('upfront_payment_amount_label');
        

        $plan_name = $customer_fname . ' ' . $customer_lname . ' | ' . $gateway->get_option('business_title') . ' Payment plan Order ID ' . $order->get_order_number();
        $price = $order->get_total();

        
        if ($gateway->get_option('different-payment-option') === 'yes') {
            if (!empty($globalMinOne) || !empty($globalMaxOne)) {
                if ($price >= $globalMinOne || $price <= $globalMaxOne) {
                    $baseurl = $gateway->get_option('base-url-one');
                } else {
                    $baseurl = $gateway->get_option('base-url');
                }
            }
            else{
                if ($price >= $globalMin) {
                    $baseurl = $gateway->get_option('base-url');
                }
            }
        } else {
            if ($price >= $globalMin) {
                $baseurl = $gateway->get_option('base-url');
            }
        }

        $source_url = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
        $currency = $order->get_currency();
        $order_recevied = $gateway->get_option('order-recevied-url');
        
        $order_meta = WC()->session->get('order_id');
        $orderDetail = wc_get_order($order_meta);

        $checkout_page_id = wc_get_page_id('checkout');
        $checkout_page = get_post($checkout_page_id);
        $post_content = $checkout_page ? $checkout_page->post_content : '';

        $shortcodeUse = strpos($post_content, '[woocommerce_checkout]') !== false 
            || strpos($post_content, '[cartflows_checkout]') !== false;

        // Check if Elementor is active and if the checkout page contains WooCommerce Checkout Blocks
        $is_elementor_checkout = false;
        if (did_action('elementor/loaded')) {
            $elementor = \Elementor\Plugin::$instance;
            $document = $elementor->documents->get($checkout_page_id);

            if ($document) {
                $is_elementor_checkout = $document->is_built_with_elementor();
            }
        }

        // Detect WooCommerce Checkout Blocks (Gutenberg or Elementor Blocks)
        $is_woo_checkout_block = strpos($post_content, '<!-- wp:woocommerce/checkout') !== false;
        // Final condition: Either Elementor is used or WooCommerce Checkout Block is present
        if ($is_elementor_checkout || $is_woo_checkout_block) {
            if (!empty($orderDetail)) {
                if ($numberInstallments == 'yes') {
                    $customer_instalment = $orderDetail->get_meta('_customer_instalment');
                }
                if ($numberInstallments == 'no' && $separatePayment == 'yes') {
                    $separate_payment = $orderDetail->get_meta('_separate_payment');
                }
                if($customerUpfront == 'yes'){
                    $upfront_payment = $orderDetail->get_meta('_customer_upfront');
                }
            }
        } else {
            if (!empty($order)) {
                if ($numberInstallments == 'yes') {
                    $customer_instalment = $order->get_meta('_customer_instalment');
                }
                if ($numberInstallments == 'no' && $separatePayment == 'yes') {
                    $separate_payment = $order->get_meta('_separate_payment');
                }
                if($customerUpfront == 'yes'){
                    $upfront_payment = $order->get_meta('_customer_upfront');
                }
            }
        }

        if (!empty($separate_payment)) {
            $baseurl = $separate_payment;
        }
        $redirect_url = $baseurl;
        if (!empty($plan_name)) {
            $redirect_url .= '?plan_name=' . urlencode($plan_name);
        }
        if (!empty($price)) {
            $redirect_url .= '&price=' . urlencode($price);
        }
        if (!empty($currency)) {
            $redirect_url .= '&currency=' . urlencode($currency) . '&s=wc&pt_status=completed&name=' . urlencode($customer_fname . ' ' . $customer_lname);
        }
        if (!empty($customer_email)) {
            $redirect_url .= '&email=' . urlencode($customer_email);
        }
        if (!empty($customer_instalment)) {
            $redirect_url .= '&number_of_payments=' . urlencode($customer_instalment);
        }
        if($customerUpfront == 'yes'){
            if (!empty($rdays)) {
                $redirect_url .= '&start_payments_after=' . urlencode($rdays);
            }
            if (!empty($upfront_payment)) {
                $redirect_url .= '&upfront_fee_value=' . urlencode($upfront_payment);
                $redirect_url .= '&upfront_fee_deduct_from_total=yes&upfront_fee_type=fixed';
            }
            if (!empty($upfrontLabel)) {
                $redirect_url .= '&upfront_fee_label='.urlencode($upfrontLabel);
            }else{
                $redirect_url .= '&upfront_fee_label=Upfront amount';
            }
        }

        // Add custom fields
        for ($i = 1; $i <= 5; $i++) {
            $custom_field_var = 'custom_field_' . $i;
            $dropdown_field_value = 'checkout_field_dropdown_' . $i;

            $custom_field_value = $gateway->get_option($custom_field_var);
            $dropdown_value = $gateway->get_option($dropdown_field_value);

            $dropdown_value = preg_replace('/^(billing|shipping)_/', '', $dropdown_value);

            if ($dropdown_value === 'order_comments') {
                $dropdown_value = $order->get_customer_note();
            } else {
                $dropdown_value = WC()->checkout->get_value($dropdown_value);
            }

            if (!empty($custom_field_value) && !empty($dropdown_value)) {
                $redirect_url .= '&' . urlencode($custom_field_value) . '=' . urlencode($dropdown_value);
            }
        }

        $pt_status = isset($_GET['pt_status']) ? $_GET['pt_status'] : null;
        $wfty_source = isset($_GET['wfty_source']) ? sanitize_text_field($_GET['wfty_source']) : 'default_value';
        $wfocu_si = isset($_GET['wfocu-si']) ? sanitize_text_field($_GET['wfocu-si']) : 'default_value';

        if($order_recevied != ''){
            // Code for funnelkit
            if (!in_array('cartflows/cartflows.php', apply_filters('active_plugins', get_option('active_plugins')))) {
                if ($pt_status === null) {
                    $order_recevied_url = $order_recevied.'?wfty_source=588&key='.$order_key.'&order_id='.$order_id.'&wfocu-si='.$wfocu_si;
                    $redirect_url .= '&customer_redirect_url='.$order_recevied_url.'&wc_order_number='.$order_number;
                    wp_redirect($redirect_url);
                }
            } else {
                // code for cartflow
                if (!isset($_GET['pt_status'])) {
                    $order_received_url = $order_recevied . '?wcf-key=' . $order->get_order_key() . '&wcf-order=' . $order->get_id();
                    $redirect_url .= '&customer_redirect_url=' . urlencode($order_received_url) . '&wc_order_number=' . urlencode($order->get_order_number());
                    ob_clean();
                    wp_redirect($redirect_url);
                }
            }
        } else {
            //code for normal flow.
            if (!isset($_GET['pt_status'])) {
                $redirect_url .= '&customer_redirect_url=' . urlencode($source_url) . '&wc_order_number=' . urlencode($order->get_order_number());
                ob_clean();
                wp_redirect($redirect_url);
            }
        }

    }
});

add_action( 'template_redirect', function(){
    if(empty( $_GET['key'] ) ) {
      return;
    }

    $order_id = wc_get_order_id_by_order_key( $_GET['key'] );
    $gateway = WC_Gateway_Paythen::instance();
    $orderStatus = $gateway->get_option('gateway_complete_status');
    $orderStatus = str_replace('wc-', '', $orderStatus);

    if ( ! $order_id )
        return;

    elseif(isset($_GET['pt_status']) && ($_GET['pt_status'] == "completed"))
    {
      // update order status
      $order = new WC_Order($order_id);
      $virtualProduct = 0;
      foreach ($order->get_items() as $order_item){
          $item = wc_get_product($order_item->get_product_id());
          if ($item->is_virtual() || $item->is_downloadable('yes')) {
            $virtualProduct = 1;
          }
      }
      
      if($virtualProduct === 1){
        if(function_exists("wc_get_order")) {
            $order = wc_get_order($order_id);
            global $wpdb;
              $table = $wpdb->prefix.'posts';
              $data = array('post_status' => 'wc-'.$orderStatus);
              $wherecondition = array('id'=>$order_id);
            $wpdb->update($table, $data, $wherecondition);
            $order->update_status($orderStatus);
        }
        else {
            $order = new WC_Order($order_id);
            global $wpdb;
              $table = $wpdb->prefix.'posts';
              $data = array('post_status' => 'wc-'.$orderStatus);
              $wherecondition = array('id'=>$order_id);
            $wpdb->update($table, $data, $wherecondition);
            $order->update_status($orderStatus);
        }
        
      }else{
        if(function_exists("wc_get_order")) {
            $order = wc_get_order($order_id);
            $order->update_status($orderStatus);
        }
        else {
            $order = new WC_Order($order_id);
            $order->update_status($orderStatus);
        }
      }
    }
});


// add custom message on order confirmation page
add_action( 'woocommerce_thankyou', 'custom_order_confirmation_message', 10, 1 );
function custom_order_confirmation_message( $order_id ) {
  if( empty( $_GET['key'] ) ) {
    return;
  }

  $order_id = wc_get_order_id_by_order_key( $_GET['key'] );
  $order = wc_get_order( $order_id );
  $order_key = $order->get_order_key();

  if( 'paythen' == $order->get_payment_method() ) {
    $gateway = WC_Gateway_Paythen::instance();
    if($gateway->get_option('note-order-confirmation')){
        echo "<h4>Payment plan note:</h4><p>".$gateway->get_option('note-order-confirmation')."</p>";
    }
  }
}

// Send custom note on order completion
add_action( 'woocommerce_email_order_meta_keys', 'add_extra_line_to_order_email');
function add_extra_line_to_order_email( $codes ) {
  if( empty( $_GET['key'] ) ) {
    return;
  }

  $order_id = wc_get_order_id_by_order_key( $_GET['key'] );
  $order = wc_get_order( $order_id );
  $order_key = $order->get_order_key();

  if( 'paythen' == $order->get_payment_method() ) {
    $gateway = WC_Gateway_Paythen::instance();
    if($gateway->get_option('note-order-confirmation')){
      $codes = "<h2>Payment plan note:</h2><p>".$gateway->get_option('note-order-confirmation')."</p>";
      echo $codes;
    }
  }
}