<?php
if( ! defined('ABSPATH') ) die('Not Allowed');

class Paythen_Admin {
  function __construct() {
    add_action( 'add_meta_boxes', array($this, 'metaBoxAdd'));
		add_action( 'woocommerce_process_product_meta', array($this, 'saveMeta'), 10, 2 );
  }

	public function metaBoxAdd() {
		$gateway = WC_Gateway_Paythen::instance();
		if($gateway->get_option('product_paythen_payment') == 'yes') {
			add_meta_box( 'paythen-product-config', __( 'Paythen payment plan', 'woo-paythen' ), array($this, 'productOptions'), 'product', 'side', 'low' );
		}
	}

	public function productOptions() {
		echo '<div class="options_group">';
		woocommerce_wp_checkbox( array(
			'id'      => 'paythen_enable',
			'value'   => get_post_meta( get_the_ID(), 'paythen_enable', true ),
			'label'   => __('Show payment plan option when this product is in the cart', 'woo-paythen'),
			'desc_tip' => true,
			'description' => __('If there are other products in the cart too, they will all be included in the payment plan total as this is calculated on the cart total including delivery fees and taxes if applicable.', 'woo-paythen'),
		) );
		echo '</div>';
	}

	public function saveMeta($id, $post) {
		if ( ! empty($_POST['paythen_enable'])) {
			update_post_meta($id, 'paythen_enable', $_POST['paythen_enable']);
		}
		else {
			delete_post_meta($id, 'paythen_enable');
		}
	}
}
