jQuery(window).on('load', function () {
    jQuery(document).ready(function ($) {
        // Function to send AJAX request
        function updateMetaData(field, value) {
            //console.log('Updating meta data:', field, value); // Log the field and value before sending AJAX request
            $.ajax({
                type: 'POST',
                url: paythenAjax.ajaxurl,
                data: {
                    action: 'paythen_checkout',
                    field: field,
                    value: value
                },
                success: function (response) {
                    if (response.success) {
                        //console.log('Meta data updated successfully');
                    } else {
                        console.error('Error:', response.data.message);
                    }
                },
                error: function (xhr, status, error) {
                    console.error('AJAX error:', status, error);
                }
            });
        }

        // Function to update meta data when page loads
        function updateMetaDataOnLoad() {
            // Retrieve customer instalment from the hidden input field
            var customerInstalment = $('#customer_instalment').val();
            updateMetaData('customer_instalment', customerInstalment);

            // Retrieve separate payment from the hidden input field
            var separatePayment = $('.separate-payment-options input[name="separate_payment"]:checked').val();
            updateMetaData('separate_payment', separatePayment);

            var customerUpfront = $('#customer_upfront').val();
            updateMetaData('customer_upfront', customerUpfront);
        }

        // Call the function to update meta data on page load
        updateMetaDataOnLoad();

        // Event handler for the dropdown
        jQuery(document).on('keyup mouseup change', '#customer_instalment', function() {
            var customerInstalment = $(this).val();
            updateMetaData('customer_instalment', customerInstalment);
        });

        // Event handler for the radio buttons
        $(document).on('change', '.separate-payment-options input[name="separate_payment"]', function () {
            var separatePayment = $(this).val();
            updateMetaData('separate_payment', separatePayment);
        });

        jQuery(document).on('keyup mouseup change', '#customer_upfront', function () {
            var customerUpfront = $(this).val();
            updateMetaData('customer_upfront', customerUpfront);
        });
    });
});

// Import necessary modules from WordPress
const { createElement, Fragment } = wp.element;
const { __ } = wp.i18n;

// Get settings from WooCommerce
const paythensettings = window.paythen_custom_gateway_data;
const paythenlabel = wp.htmlEntities.decodeEntities(paythensettings.title) || __('Paythen Custom Gateway', 'paythen_custom_gateway');

// Function to create and return the content as a React element
const createPaythenContent = () => {
    // Generate the description content
    const description = wp.htmlEntities.decodeEntities(paythensettings.description || '');

    // Create description element
    const descriptionElement = createElement('div', { className: 'paythen-description' }, description);

    let upfrontField = null; // Declare upfrontField in the correct scope
    if (paythensettings.upfrontAmount === 'yes') {
        const minUpfrontAmont = paythensettings.minUpfrontAmount;
        upfrontField = createElement('div', { className: 'paythen-fields installment-options' },
            createElement('label', { htmlFor: 'customer_upfront' }, __('What amount would you like to pay now?', 'woocommerce')),
            createElement('input', { type: 'number', id: 'customer_upfront', name: 'customer_upfront', min: minUpfrontAmont,placeholder: 'Eg: 500'})
        );
    }

    // Create Installment Field if applicable
    let installmentField = null;
    const minInstallment = parseInt(paythensettings.minInstallment);
    const maxInstallment = parseInt(paythensettings.maxInstallment);
    if (paythensettings.numberInstallments === 'yes') {
        if (paythensettings.upfrontAmount === 'yes') {
             if (minInstallment && maxInstallment) {
                const options = [];
                for (let i = minInstallment; i <= maxInstallment; i++) {
                    options.push(createElement('option', { value: i, key: i, selected: i === minInstallment }, i));
                }
                installmentField = createElement('div', { className: 'paythen-fields installment-options' },
                    createElement('label', { htmlFor: 'customer_instalment' }, __('How many payments would would you like the rest of your balance to be split into?', 'woocommerce')),
                    createElement('select', { id: 'customer_instalment', name: 'customer_instalment' }, options)
                );
            } else {
                const defaultValue = minInstallment ? minInstallment : '';
                installmentField = createElement('div', { className: 'paythen-fields installment-options' },
                    createElement('label', { htmlFor: 'customer_instalment' }, __('How many payments would would you like the rest of your balance to be split into?', 'woocommerce')),
                    createElement('input', { type: 'number', id: 'customer_instalment', name: 'customer_instalment', defaultValue: defaultValue })
                );
            }
        } else {
            if (minInstallment && maxInstallment) {
                // Create dropdown if both minimum and maximum installments are defined
                const options = [];
                for (let i = minInstallment; i <= maxInstallment; i++) {
                    options.push(createElement('option', { value: i, key: i, selected: i === minInstallment }, i));
                }
                installmentField = createElement('div', { className: 'paythen-fields installment-options' },
                    createElement('label', { htmlFor: 'customer_instalment' }, __('How many payments would you like your plan to be?', 'woocommerce')),
                    createElement('select', { id: 'customer_instalment', name: 'customer_instalment' }, options)
                );
            } else {
                const defaultValue = minInstallment ? minInstallment : '';
                // Create number input field if either or both minimum and maximum installments are not defined
                installmentField = createElement('div', { className: 'paythen-fields installment-options' },
                    createElement('label', { htmlFor: 'customer_instalment' }, __('How many payments would you like your plan to be? ', 'woocommerce')),
                    createElement('input', { type: 'number', id: 'customer_instalment', name: 'customer_instalment', defaultValue: defaultValue })
                );
            }
        }
    }

    const cartTotal = paythensettings ? paythensettings.carttotalVal : 0; // Default to 0 if undefined
    const currencySymbol = paythensettings ? paythensettings.currency_format_symbol : '$'; // Default to '$' if undefined
    const remainingDays = paythensettings ? paythensettings.remainingPaymentDays : '30'; // Default to 30 days

    // Add the hidden field with data attributes
    const cartTotalElement = createElement('div', {
        className: 'cart-total',
        'data-total': cartTotal,
        'data-currency': currencySymbol,
        'data-rdays': remainingDays
    });

    // Create Separate Payment Options if applicable
    const separatePaymentOptions = paythensettings.separatePayment === 'yes' ? createElement('div', { className: 'separate-payment-options' },
        createElement('label', { id: 'separate-label-choose-payment', className: 'separate-label' }, __('Choose your payment option', 'woocommerce')),
        ...paythensettings.paymentOptions.map((option, index) =>
            createElement('div', { key: option.url },
                createElement('input', { id: `separate-payment-option-${index}`, type: 'radio', name: 'separate_payment', value: option.url, defaultChecked: index === 0 }),
                createElement('label', { htmlFor: `separate-payment-option-${index}` }, option.title)
            )
        )
    ) : null;

    // Combine all parts into a single content element
    return createElement(Fragment, null, descriptionElement, upfrontField, installmentField, separatePaymentOptions, cartTotalElement);
};

// Register the payment method
const Paythen_Block_Gateway = {
    name: 'paythen',
    label: paythenlabel,
    content: createElement(createPaythenContent),
    edit: createElement(createPaythenContent),
    canMakePayment: () => true,
    ariaLabel: paythenlabel,
    supports: {
        features: paythensettings.supports,
    },
};

// Ensure the registry is ready and then register the payment method
if (window.wc && window.wc.wcBlocksRegistry) {
    window.wc.wcBlocksRegistry.registerPaymentMethod(Paythen_Block_Gateway);
} else {
    console.error('WooCommerce Blocks registry is not available.');
}