<?php

if ( ! defined( 'ABSPATH' ) ) exit;

class WC_Gateway_paythen extends WC_Payment_Gateway {

    public static $log = false;
    private static $_instance = NULL;

    const PLUGIN_VERSION = '0.9.4';


    const NOTIFICATION_PATH = '/paythen-notification';

    public static function instance() {
        if (is_null(self::$_instance)) {
            self::$_instance = new self();
        }
        return self::$_instance;
    }

    public function __construct() {
        global $woocommerce;
        $this->id = 'paythen';
        // title and description merchant sees in wp admin
        $this->method_title = __('Paythen Payment Plan', 'woo_paythen');
        $this->method_description = __("Offer your customers an easy payment plan at checkout. You'll need to <a href='https://paythen.co/woocommerce-plugin/account-sign-up/?utm_source=self&utm_medium=woocommerce&utm_campaign=plugin&utm_content=plugin-settings' target='_blank'>create a free Paythen account</a> to set this up. Takes under a minute.", 'woo_paythen');
        $this->icon = 'https://paythen.parts/woocommerce/plugin/images/paythen-icon.svg';
        $this->supports = array('products');
        $this->init_form_fields();
        $this->init_settings();
        $this->title = $this->get_option('title');
        // description customer sees at checkout
        $this->description = $this->get_option('description');

        add_action('woocommerce_update_options_payment_gateways_' . $this->id, array( $this, 'process_admin_options' ));

    }

    public static function log($message) {
        if (empty(self::$log)) {
            self::$log = new WC_Logger();
        }
        self::$log->add('Paythen', $message);
    }

    function init_form_fields() {
      $dropdown_options = array();
        
        if (isset($_GET['section']) && $_GET['section'] === 'paythen') {
            // Create an instance of WC_Countries
            $countries = new WC_Countries();

            // Get all billing fields
            $billing_fields = $countries->get_address_fields(
                $countries->get_base_country(),
                'billing_'
            );

            // Get all shipping fields
            $shipping_fields = $countries->get_address_fields(
                $countries->get_base_country(),
                'shipping_'
            );

            // Additional checkout fields (order-related)
            $additional_checkout_fields = array(); // Add any custom fields if necessary

            // Merge all fields into one array
            $all_checkout_fields = array_merge($billing_fields, $shipping_fields, $additional_checkout_fields);

            // Generate dropdown options for all fields
            $dropdown_options = array();
            foreach ($billing_fields as $key => $field) {
                $dropdown_options['billing_' . $key] = 'Billing: ' . $field['label'];
            }
            foreach ($shipping_fields as $key => $field) {
                $dropdown_options['shipping_' . $key] = 'Shipping: ' . $field['label'];
            }
            foreach ($additional_checkout_fields as $key => $field) {
                $dropdown_options[$key] = $field['label'];
            }

            // Use $dropdown_options as needed
        }
      $fields = array(
            'enabled' => array(
                'title' => __( 'Enable Paythen at checkout', 'woo_paythen' ),
                'type' => 'checkbox',
                'label' => __( 'Check this box to show Paythen as a payment option on the checkout page.', 'woo_paythen' ),
                'default' => 'yes'
            ),
            'title' => array(
                'title' => __( 'Payment method title', 'woo_paythen' ),
                'type' => 'text',
                'description' => __( 'This is the name your customers will see on the checkout page. This will show along with any other payment methods you have enabled. We suggest keeping descriptive. Eg: EASY PAYMENT PLAN', 'woo_paythen' ),
                'default' => __( 'EASY PAYMENT PLAN', 'woo_paythen' ),
                'desc_tip' => true
            ),
          'business_title' => array(
                'title' => __( 'Business name', 'woo_paythen' ),
                'type' => 'text',
                'description' => __( 'This will be shown to customers on the payment plan page.', 'woo_paythen' ),
                'default' => __( '', 'woo_paythen' ),
                'desc_tip' => true
            ),
            'description' => array(
                'title' => __( 'Description', 'woo_paythen' ),
                'type' => 'text',
                'description' => __( "This shows if your customers choose this payment method. Use this to provide more context about your payment plan. Eg: Pay over 8 weeks with your credit or debit card. You'll pay on the next page.", 'woo_paythen' ),
                'default' => __('Pay for your order over easy installments using your credit or debit card. Click on the button below - payment will be on the next screen.', 'woo_paythen' ),
                'desc_tip' => true
            ),
            'order-recevied-url' => array(
                'title' => __( 'Custom order confirmation page url (if applicable)', 'woo_paythen' ),
                'type' => 'text',
                'default' => '',
                'description' => __( 'If you&apos;re using a custom order confirmation page, add the link here, otherwise leave it blank', 'woo_paythen'),
            ),
            'product_paythen_payment' => array(
                'title' => __( 'Enable Paythen for specific products only', 'woo_paythen' ),
                'type' => 'checkbox',
                'default' => '',
                'label' => ("Enabling this will show a new checkbox on each WooCommerce product page. Go to each product and check the &ldquo;Paythen payment plan&rdquo; box to switch this on for that product. This will make the Paythen payment plan option appear only when these selected products are in the customer's cart."),
                'class' => 'product-paythen-payment',
            ),
            'product_paythen_information' => array(
                'title' => __( 'Show “payment plans available” text on product pages', 'woo_paythen' ),
                'type' => 'checkbox',
                'default' => 'yes',
                'label'   => __( 'Show “payment plans available” text + how it works pop up on product pages when customers click the information icon for more info.', 'woo_paythen' ),
                'class' => 'product-information',
            ),
            'paythen_information_text' => array(
                'title' => __( 'Add additional text in the how it works pop-up', 'woo_paythen' ),
                'type' => 'textarea',
                'default' => '',
                'description'   => __( 'This is shown in addition to our default text. You can view an example of our default pop-up on <a href="https://paythen.co/woocommerce-plugin/product-page-modal-demo" target="_blank">our demo store.</a>', 'woo_paythen' ),
                'class' => 'information-text',
            ),
            'upfront-payment-amount-option' => array(
                'title'   => __( 'Let customers choose the upfront payment amount (charged immediately)', 'woo_paythen' ),
                'type'    => 'checkbox',
                'default' => '',
                'label'   => __( "This will let each customer choose the portion of their order total they pay immediately as an upfront payment / deposit", 'woo_paythen' ),
                'class'   => 'upfront-payment',
            ),
            'amount_upfront_type' => array(
                'title'       => __( 'Set a range for the upfront amount (optional)', 'woo_paythen' ),
                'type'        => 'select',
                'options'     => array(
                    'fixed'     => __( 'Fixed Amount', 'woo_paythen' ),
                    'percentage' => __( 'Percentage', 'woo_paythen' ),
                ),
                'default'     => 'fixed',
                'class'       => 'max-one-upfront-payment-type',
                'desc_tip'    => true,
                'description' => __( 'You can optionally limit the upfront amount a customers can pay by entering either a fixed dollar amount or a percentage amount. Eg: If you want customers to pay a minimum 20% deposit of their total, choose "Percentage" here and enter 20 in the "Minimum upfront amount field".', 'woo_paythen' ),
            ),
            'min_amount_one_upfront' => array(
                'title'       => __( 'Minimum upfront amount (optional)', 'woo_paythen' ),
                'type'        => 'text',
                'description' => __( 'Enter a minimum percentage or fixed value (based on what you chose above) for each customer. If you want to ensure every customer pays at least $200 upfront, then you can choose the "Fixed amount" option above and enter 200 here.', 'woo_paythen' ),
                'desc_tip'    => true,
                'class'       => 'min-one-upfront-payment',
            ),
            'max_amount_one_upfront' => array(
                'title'       => __( 'Maximum upfront amount (optional)', 'woo_paythen' ),
                'type'        => 'text',
                'description' => __( "If you'd like to restrict the maximum a customer can pay as an upfront portion of their payment plan, you can set a maximum here as a percentage or fixed amount based on what you chose in the dropdown above.", 'woo_paythen' ),
                'desc_tip'    => true,
                'class'       => 'max-one-upfront-payment',
            ),
            'remaining_payment_days_upfront' => array(
                'title'       => __( 'How many days later should the first installment (of the remaining amount) be charged)? Eg: 7, or 30.', 'woo_paythen' ),
                'type'        => 'text',
                'description' => __( "The upfront payment amount is charged immediately. This field is where you can decide when the next payment will be charged. If your plan is weekly, you can enter 7, if it's monthly, you can enter 30.", 'woo_paythen' ),
                'desc_tip'    => true,
                'class'       => 'remaining-payment-days',
            ),
            'upfront_payment_amount_label' => array(
                'title'       => __( 'Upfront payment amount label', 'woo_paythen' ),
                'type'        => 'text',
                'desc_tip'    => true,
                'description' => 'Deposit the text "(paid today) is automatically added to whatever text you enter here. So if you enter Deposit, customers will see Deposit (paid today) on their payment plan page.',
                'class'       => 'upfront-payment-label',
            ),
            'number-installments' => array(
                'title' => __( 'Let customers choose the number of installments', 'woo_paythen' ),
                'type' => 'checkbox',
                'default' => '',
                'label'   => __( "This will let each customer choose the number of payments at checkout <em>(This can't be used with the 'Offer multiple payment plans' option. Switch that off to use this)</em>", 'woo_paythen' ),
                'class' => 'number-installment',
            ),
            'min_installment' => array(
                'title' => __( 'Enter a minimum number of installments', 'woo_paythen' ),
                'type' => 'number',
                'default'=> '2',
                'custom_attributes' => array('step' => '1','min' => '2','required' => 'required'),
                'description' => 'Must be 2 or more. This is the minimum number of payments your customers can choose. This will also be the default value shown.','woo_paythen',
                'desc_tip'=> true,
                'class' => 'min-installment',
            ),
            'max_installment' => array(
                'title' => __( 'Enter a maximum number of installments (optional)', 'woo_paythen' ),
                'type' => 'number',
                'default'=> '',
                'custom_attributes' => array('step' => '1','min' => '3'),
                'description' => 'Leave this blank to let customers choose any maximum number.','woo_paythen',
                'desc_tip' => true,
                'class' => 'max-installment',
            ),
            'different-payment-option' => array(
                'title' => __( 'Add a different payment plan option based on the total amount ', 'woo_paythen' ),
                'type' => 'checkbox',
                'default' => '',
                'label'=> ("Add a different payment plan option based on the total amount <em>(This can't be used with the 'Offer multiple payment plans' option. Switch that off to use this)</em>"),
                'class' => 'different-payment',
            ),
            'min_amount' => array(
                'title' => __( 'Minimum order amount', 'woo_paythen' ),
                'type' => 'text',
                'description' => __( "If you'd like the payment plan option to show only when the total is above a certain amount, enter the value here without any symbols. Eg: 500. Leave this blank to always show the payment plan option.", 'woo_paythen' ),
                'desc_tip' => true,
                'class' => 'min-payment',
            ),
            'max_amount' => array(
                'title' => __( 'Maximum order amount', 'woo_paythen' ),
                'type' => 'text',
                'description' => __( 'Enter an maximum amount here to only enable Paythen for orders over the amount given', 'woo_paythen' ),
                'desc_tip' => true,
                'class' => 'max-payment',
            ),
            'base-url' => array(
                'title' => __( 'Paythen template url', 'woo_paythen' ),
                'type' => 'text',
                'default' => '',
                'description' => __( 'Paste the template url in from your <a href="http://paythen.co/woocommerce-plugin/paythen-account?utm_source=self&utm_medium=woocommerce&utm_campaign=plugin&utm_content=plugin-settings" target="_blank">Paythen account</a>. Read more <a href="https://paythen.co/woocommerce-plugin/templates-help/" target="blank">here</a>.', 'woo_paythen'),
                'class' => 'base-url',
            ),
            'min_amount_one' => array(
                'title' => __( 'Minimum order amount 2', 'woo_paythen' ),
                'type' => 'text',
                'description' => __( "If you'd like the payment plan option to show only when the total is above a certain amount, enter the value here without any symbols. Eg: 500. Leave this blank to always show the payment plan option.", 'woo_paythen' ),
                'desc_tip' => true,
                'class' => 'min-one-payment',
            ),
            'max_amount_one' => array(
                'title' => __( 'Maximum order amount 2', 'woo_paythen' ),
                'type' => 'text',
                'description' => __( 'Enter an maximum amount here to only enable Paythen for orders over the amount given', 'woo_paythen' ),
                'desc_tip' => true,
                'class' => 'max-one-payment',
            ),
            'base-url-one' => array(
                'title' => __( 'Paythen template url 2', 'woo_paythen' ),
                'type' => 'text',
                'default' => '',
                'description' => __( 'Paste the template url in from your <a href="http://paythen.co/woocommerce-plugin/paythen-account?utm_source=self&utm_medium=woocommerce&utm_campaign=plugin&utm_content=plugin-settings" target="_blank">Paythen account</a>. Read more <a href="https://paythen.co/woocommerce-plugin/templates-help/" target="blank">here</a>.', 'woo_paythen'),
                'class' => 'base-url-one',
            ),
            'separate-payment-option' => array(
                'title' => __( 'Offer multiple payment plans', 'woo_paythen' ),
                'type' => 'checkbox',
                'default' => '',
                'label'   => __( 'Enable this to offer more than one payment plan option. Eg: 4 month plan, 8 month plan etc.', 'woo_paythen' ),
                'class' => 'separate-payment',
            ),
            'payment-title-one' => array(
                'title' => __( 'Payment plan option 1 title', 'woo_paythen' ),
                'type' => 'text',
                'default' => '',
                'description' => __( 'This is the text customers will see to select this option under the main title and description you’ve set above. Eg: 4 month plan', 'woo_paythen'),
                'class' => 'payment-title-one payment-methods',
            ),
            'payment-url-one' => array(
                'title' => __( 'Payment plan option 1 template url', 'woo_paythen' ),
                'type' => 'text',
                'default' => '',
                'description' => __( 'Paste the template url in from your <a href="http://paythen.co/woocommerce-plugin/paythen-account?utm_source=self&utm_medium=woocommerce&utm_campaign=plugin&utm_content=plugin-settings" target="_blank">Paythen account</a>. Read more <a href="https://paythen.co/woocommerce-plugin/templates-help/" target="blank">here</a>.', 'woo_paythen'),
                'class' => 'payment-url-one payment-methods',
            ),
            'payment-title-two' => array(
                'title' => __( 'Payment plan option 2 title', 'woo_paythen' ),
                'type' => 'text',
                'default' => '',
                'description' => __( 'This is the text customers will see to select this option under the main title and description you’ve set above. Eg: 4 month plan', 'woo_paythen'),
                'class' => 'payment-title-two payment-methods',
            ),
            'payment-url-two' => array(
                'title' => __( 'Payment plan option 2 template url', 'woo_paythen' ),
                'type' => 'text',
                'default' => '',
                'description' => __( 'Paste the template url in from your <a href="http://paythen.co/woocommerce-plugin/paythen-account?utm_source=self&utm_medium=woocommerce&utm_campaign=plugin&utm_content=plugin-settings" target="_blank">Paythen account</a>. Read more <a href="https://paythen.co/woocommerce-plugin/templates-help/" target="blank">here</a>.', 'woo_paythen'),
                'class' => 'payment-url-two payment-methods',
            ),
            'payment-title-three' => array(
                'title' => __( 'Payment plan option 3 title', 'woo_paythen' ),
                'type' => 'text',
                'default' => '',
                'description' => __( 'This is the text customers will see to select this option under the main title and description you’ve set above. Eg: 4 month plan', 'woo_paythen'),
                'class' => 'payment-title-three payment-methods',
            ),
            'payment-url-three' => array(
                'title' => __( 'Payment plan option 3 template url', 'woo_paythen' ),
                'type' => 'text',
                'default' => '',
                'description' => __( 'Paste the template url in from your <a href="http://paythen.co/woocommerce-plugin/paythen-account?utm_source=self&utm_medium=woocommerce&utm_campaign=plugin&utm_content=plugin-settings" target="_blank">Paythen account</a>. Read more <a href="https://paythen.co/woocommerce-plugin/templates-help/" target="blank">here</a>.', 'woo_paythen'),
                'class' => 'payment-url-three payment-methods',
            ),
            'gateway_complete_status' => array(
              'title' => __( 'Paythen order status', 'woo_paythen'),
              'type' => 'select',
              'options' => wc_get_order_statuses(),
              'default' => 'processing',
              'description' => __( 'After a payment plan is created, set the order status to this', 'woo_paythen'),
              'desc_tip' => true
            ),
            'note-order-confirmation' => array(
                'title' => __( 'Add an optional note that will show on the order confirmation page and in the order confirmation email sent to customers', 'woo_paythen' ),
                'type' => 'textarea',
                'default' => '',
                'description' => __( "If you add text here, it will show at the bottom of the WooCommerce order confirmation page after they have signed up to their payment plan. It will also show in the WooCommerce order confirmation email sent to customers. If you're using a custom confirmation page or emails, this will not show", 'woo_paythen'),
                'desc_tip' => true,
                'class' => 'information-text note-order-confirmation',
                'placeholder' => "Eg: We've emailed you your payment plan dates and your personal link to manage your plan. We're processing your order now and will email you with updates."
            ),
            'additional-custom-field' => array(
                'title' => __( 'Pass additional values via custom fields', 'woo_paythen' ),
                'type' => 'checkbox',
                'default' => '',
                'class' => 'additional-custom-field',
            ),
        );
        //$this->form_fields = array_merge($fields);
        
        // Add custom text field
        $fields['custom_field_1'] = array(
            'title' => __('Custom field 1 Paythen field ID', 'woo_paythen'),
            'type' => 'text',
            'description' => __('Enter custom field parameters.', 'woo_paythen'),
            'default' => '',
            'desc_tip' => true,
            'class'=> 'checkout_custom_field'
        );
        // Add dropdown field
        $fields['checkout_field_dropdown_1'] = array(
            'title' => __('Pass this WooCommerce field', 'woo_paythen'),
            'type' => 'select',
            'options' => array_merge(array('' => 'Select an option'), $dropdown_options),
            'default' => '',
            'description' => __('Select a custom field from the dropdown.', 'woo_paythen'),
            'desc_tip' => true,
            'class'=> 'checkout_custom_field'
        );

        // Add custom text field 2
        $fields['custom_field_2'] = array(
            'title' => __('Custom field 2 Paythen field ID', 'woo_paythen'),
            'type' => 'text',
            'description' => __('Enter the custom field ID shown on the Paythen plan summary page.', 'woo_paythen'),
            'default' => '',
            'desc_tip' => true,
            'class'=> 'checkout_custom_field'
        );

        // Add dropdown field 2
        $fields['checkout_field_dropdown_2'] = array(
            'title' => __('Pass this WooCommerce field', 'woo_paythen'),
            'type' => 'select',
            'options' => array_merge(array('' => 'Select an option'), $dropdown_options),
            'default' => '',
            'description' => __('Select a custom field from the dropdown.', 'woo_paythen'),
            'desc_tip' => true,
            'class'=> 'checkout_custom_field'
        );

        // Add custom text field 3
        $fields['custom_field_3'] = array(
            'title' => __('Custom field 3 Paythen field ID', 'woo_paythen'),
            'type' => 'text',
            'description' => __('Enter the custom field ID shown on the Paythen plan summary page.', 'woo_paythen'),
            'default' => '',
            'desc_tip' => true,
            'class'=> 'checkout_custom_field'
        );

        // Add dropdown field 3
        $fields['checkout_field_dropdown_3'] = array(
            'title' => __('Pass this WooCommerce field', 'woo_paythen'),
            'type' => 'select',
            'options' => array_merge(array('' => 'Select an option'), $dropdown_options),
            'default' => '',
            'description' => __('Select a custom field from the dropdown.', 'woo_paythen'),
            'desc_tip' => true,
            'class'=> 'checkout_custom_field'
        );

        // Add custom text field 4
        $fields['custom_field_4'] = array(
            'title' => __('Custom field 4 Paythen field ID', 'woo_paythen'),
            'type' => 'text',
            'description' => __('Enter the custom field ID shown on the Paythen plan summary page.', 'woo_paythen'),
            'default' => '',
            'desc_tip' => true,
            'class'=> 'checkout_custom_field'
        );

        // Add dropdown field 4
        $fields['checkout_field_dropdown_4'] = array(
            'title' => __('Pass this WooCommerce field', 'woo_paythen'),
            'type' => 'select',
            'options' => array_merge(array('' => 'Select an option'), $dropdown_options),
            'default' => '',
            'description' => __('Select a custom field from the dropdown.', 'woo_paythen'),
            'desc_tip' => true,
            'class'=> 'checkout_custom_field'
        );

        // Add custom text field 5
        $fields['custom_field_5'] = array(
            'title' => __('Custom field 5 Paythen field ID', 'woo_paythen'),
            'type' => 'text',
            'description' => __('Enter the custom field ID shown on the Paythen plan summary page.', 'woo_paythen'),
            'default' => '',
            'desc_tip' => true,
            'class'=> 'checkout_custom_field'
        );

        // Add dropdown field 5
        $fields['checkout_field_dropdown_5'] = array(
            'title' => __('Pass this WooCommerce field', 'woo_paythen'),
            'type' => 'select',
            'options' => array_merge(array('' => 'Select an option'), $dropdown_options),
            'default' => '',
            'description' => __('Select a custom field from the dropdown.', 'woo_paythen'),
            'desc_tip' => true,
            'class'=> 'checkout_custom_field'
        );

        $fields['Version'] = array(
            'title' => __('Version 0.9.4', 'woo_paythen'),
            'type' => 'title',
            //'description' => __('This group contains a custom text field, an input box, and a dropdown.', 'woo_paythen')
        );
        
        // Merge the dynamic fields with existing fields
        $this->form_fields = array_merge($fields, $this->form_fields);
    }

    function process_payment($order_id) {
        global $woocommerce;
        if( function_exists("wc_get_order") ) {
            $order = wc_get_order($order_id);
        }
        else {
            $order = new WC_Order($order_id);
        }

        return $this->get_redirect_url($order);
    }

    function get_redirect_url($order) {
        return array(
            'result' => 'success',
            'redirect' => $this->get_return_url($order)
        );
    }

    function paythen_payment_callback($order_id) {
        if(function_exists("wc_get_order")) {
            $order = wc_get_order($order_id);
        }
        else {
            $order = new WC_Order($order_id);
        }

        $status = $this->get_option('gateway_complete_status');

        // only do this for paythen payments
        if ($order && $order->get_payment_method() == 'paythen') {
          if ($status == 'paid') {
            // no "paid" status in woo, comparable is "completed"
            $order->update_status('on-hold', __('Paythen payment plan created', 'woo_paythen'));
            $order->payment_complete();
          }
          else {
            $order->update_status($status, __('Paythen payment plan created', 'woo_paythen'));
            if (function_exists('wc_reduce_stock_levels')) {
              wc_reduce_stock_levels($order_id);
            }
            else {
              $order->reduce_order_stock();
            }
          }
        }

        return $order_id;
    }

    function get_base_url() {
        $url = $this->get_option('base-url');

        if (substr($url, -1) == '/') {
            $url = substr($url, 0, -1);
        }

        return $url;
    }

    function get_create_checkout_url() {
      return $this->get_base_url() . '/gateway_purchase_url';
    }

    function get_offers() {
      $req = array(
          'headers' => array(
              'Content-Type'    => 'application/json',
              'Authorization' => 'Bearer ' . $this->get_option('api-key')
          )
      );
      $url = $this->get_base_url() . '/offer';
      $res = wp_remote_get($url, $req);
      if (is_array($res) && wp_remote_retrieve_response_code($res) == 200) {
        return json_decode( wp_remote_retrieve_body($res) );
      }
      else {
        return array();
      }
    }

    public static function currentLanguage() {
      $locale = get_locale();
      $locale_parts = explode('_', $locale);
      return $locale_parts[0];
    }

}

function wc_price_to_number($formatted_price) {
    // Remove any non-numeric characters, including currency symbols, commas, and any HTML tags
    $price = preg_replace('/[^0-9.,]+/', '', strip_tags($formatted_price));

    // Replace any comma (,) with a period (.) for decimal separation
    $price = str_replace(',', '.', $price);

    // Cast to a float (or integer, if there are no decimal places)
    return floatval($price);
}

//set session for wc orders
add_action('woocommerce_loaded', function () {
    if (WC()->session && !WC()->session->has_session()) {
        WC()->session->set_customer_session_cookie(true);
    }
});

add_filter('woocommerce_gateway_description', 'gateway_paythen_custom_fields', 20, 2);

function gateway_paythen_custom_fields($description, $payment_id) {
    if ('paythen' !== $payment_id) {
        return $description;
    }

    $gateway = WC_Gateway_Paythen::instance();
    $cartTotal = WC()->cart->get_total(null);
    $currencySign = get_woocommerce_currency_symbol();
    $numberInstallments = $gateway->get_option('number-installments');
    $separatePayment = $gateway->get_option('separate-payment-option');
    $minimumInstallment = floatval($gateway->get_option('min_installment'));
    $maximumInstallment = floatval($gateway->get_option('max_installment'));

    $payment_options = [
        $gateway->get_option('payment-title-one') => $gateway->get_option('payment-url-one'),
        $gateway->get_option('payment-title-two') => $gateway->get_option('payment-url-two'),
        $gateway->get_option('payment-title-three') => $gateway->get_option('payment-url-three')
    ];

    // Filter out empty payment options
    $payment_options = array_filter($payment_options, function ($url, $title) {
        return !empty($title) && !empty($url);
    }, ARRAY_FILTER_USE_BOTH);

    // Calculate minimum deposit amount
    $upfront_payment_enabled = $gateway->get_option('upfront-payment-amount-option'); // Checkbox to allow upfront payment
    $amount_upfront_type = $gateway->get_option('amount_upfront_type'); // 'fixed' or 'percentage'
    $min_upfront_value = (int) $gateway->get_option('min_amount_one_upfront'); 
    $max_upfront_value = (int) $gateway->get_option('max_amount_one_upfront');
    $rdays = $gateway->get_option('remaining_payment_days_upfront');

    $min_upfront_amount = null; // Default to null (do nothing)

    if ($upfront_payment_enabled === 'yes') {
        // If a fixed amount is selected, use it directly.
        if ($amount_upfront_type === 'fixed' && $min_upfront_value > 0) {
            $min_upfront_amount = $min_upfront_value;
        }
        // If percentage is selected, calculate the amount.
        elseif ($amount_upfront_type === 'percentage' && $min_upfront_value > 0) {
            $min_upfront_amount = ceil(($cartTotal * $min_upfront_value) / 100);
        }

        // Ensure the upfront amount is not below the minimum installment.
        if ($min_upfront_amount !== null) {
            $min_upfront_amount = max($minimumInstallment, $min_upfront_amount);

            // If max upfront amount is set, ensure it does not exceed that value.
            //if ($max_upfront_value > 0) {
                //$max_upfront_value = min($min_upfront_amount, $max_upfront_value);
            //}

            $min_upfront_display = wc_price($min_upfront_amount);
        } else {
            $min_upfront_display = ''; // Hide if no value is set
        }
    }

    ob_start();
    echo '<div class="paythen-fields" style="padding:10px 0;">';
    if ($upfront_payment_enabled === 'yes') {
        echo '<div> <label for="customer_upfront">' . esc_html__('What amount would you like to pay now?', 'woocommerce') . '</label>';
        echo '<input type="number" class="input-text" id="customer_upfront" name="customer_upfront" min="' . esc_attr($min_upfront_amount) . '" placeholder="Eg: 500" step="1"></div>';/* if(!empty($min_upfront_amount)){echo '<div class="minimum-text">' . sprintf(esc_html__('Minimum amount required: %s', 'woocommerce'), $min_upfront_display) . '</div>';}*/
    }

    if ($numberInstallments === 'yes') {
        if (!empty($maximumInstallment)) {
            if ($upfront_payment_enabled === 'yes') {echo '<label for="customer_instalment">' . esc_html__('How many payments would would you like the rest of your balance to be split into?', 'woocommerce') . '</label>';}else{echo '<label for="customer_instalment">' . esc_html__('How many payments would you like your plan to be?', 'woocommerce') . '</label>';}
            echo '<select id="customer_instalment" name="customer_instalment">';
            for ($i = $minimumInstallment; $i <= $maximumInstallment; $i++) {
                echo '<option value="' . esc_attr($i) . '">' . esc_html($i) . '</option>';
            }
            echo '</select>';
        } else {
            if ($upfront_payment_enabled === 'yes') {
                woocommerce_form_field('customer_instalment', [
                    'type'  => 'number',
                    'placeholder' => $minimumInstallment,
                    'label' => esc_html__('How many payments would would you like the rest of your balance to be split into?', 'woocommerce'),
                    'class' => ['form-row-wide'],
                    'custom_attributes' => ['step' => '1']
                ], '');
            }else{
                woocommerce_form_field('customer_instalment', [
                    'type'  => 'number',
                    'placeholder' => $minimumInstallment,
                    'label' => esc_html__('How many payments would you like your plan to be?', 'woocommerce'),
                    'class' => ['form-row-wide'],
                    'custom_attributes' => ['step' => '1']
                ], '');
            }
        }
    } 
    if ($separatePayment === 'yes' && !empty($payment_options)) {
        echo '<div class="separate-payment-options">';
        echo '<label class="separate-label">' . esc_html__('Choose a payment plan option:', 'woocommerce') . '</label>';
        $count_id = 0;
        foreach ($payment_options as $title => $url) {
            $checked = $count_id === 0 ? 'checked' : '';
            echo '<input type="radio" name="separate_payment" id="separate_payment_' . esc_attr($count_id) . '" value="' . esc_attr($url) . '" ' . $checked . '>';
            echo '<label for="separate_payment_' . esc_attr($count_id) . '">' . esc_html($title) . '</label><br>';
            $count_id++;
        }
        echo '</div>';
    } 

    echo '</div>';
    echo '<div class="cart-total" data-total="'.esc_attr($cartTotal).'"data-currency="'.esc_attr($currencySign).'"data-rdays="'.esc_attr($rdays).'"></div>';

    return $description . ob_get_clean();
}


// Handle the checkout form submission
function handle_paythen_checkout() {
    if (!isset($_POST['field']) || !isset($_POST['value'])) {
        wp_send_json_error(array('message' => 'Invalid form data'));
    }

    $field = sanitize_text_field($_POST['field']);
    $value = sanitize_text_field($_POST['value']);

    // Get order ID from session or create new order
    $order_id = WC()->session->get('order_id');
    if (!$order_id) {
        $order = wc_create_order();
        $order_id = $order->get_id();
        WC()->session->set('order_id', $order_id);
    }

    $order = wc_get_order($order_id);

    // Save custom fields to order meta directly from AJAX request
    if ($field === 'customer_instalment') {
        $order->update_meta_data('_customer_instalment', $value);
    }
    
    if ($field === 'separate_payment') {
        $order->update_meta_data('_separate_payment', $value);
    }

    if ($field === 'customer_upfront') {
        $order->update_meta_data('_customer_upfront', $value);
    }

    $order->save();
    wp_send_json_success();
}
add_action('wp_ajax_paythen_checkout', 'handle_paythen_checkout');
add_action('wp_ajax_nopriv_paythen_checkout', 'handle_paythen_checkout');

// Checkout custom field save to order meta
add_action('woocommerce_checkout_create_order', 'save_paythen_option_order_meta', 10, 2 );
function save_paythen_option_order_meta( $order, $data ) {
    if ( isset($_POST['customer_instalment']) && ! empty($_POST['customer_instalment']) ) {
        $order->update_meta_data( '_customer_instalment' , esc_attr($_POST['customer_instalment']) );
    }
    if ( isset($_POST['separate_payment']) && ! empty($_POST['separate_payment']) ) {
        $order->update_meta_data( '_separate_payment' , esc_attr($_POST['separate_payment']) );
    }
    if ( isset($_POST['customer_upfront']) && ! empty($_POST['customer_upfront']) ) {
        $order->update_meta_data( '_customer_upfront' , esc_attr($_POST['customer_upfront']) );
    }
}

/* add custom modal next to single product price */
add_filter( 'woocommerce_after_add_to_cart_button', 'add_content_after_addtocart_button_func', 10, 2 );
function add_content_after_addtocart_button_func() {
    global $product;
    $product_id = method_exists( $product, 'get_id' ) ? $product->get_id() : $product->id;
    $gateway = WC_Gateway_Paythen::instance();  
    if($gateway->get_option('product_paythen_information') == 'yes'){
        if($gateway->get_option('product_paythen_payment') == 'yes') {
            if (get_post_meta($product_id, 'paythen_enable', true ) == 'yes') {
                $custom_text = '<div class="paythen-modal-main"><a href="javascript:void(0)" class="paythen-modal"><b>Easy payment plan available.</b> Choose this option at checkout <span class="information-icon"></span></a></div>';
                echo $custom_text.'<div class="pop-upbox continue-payment-popup" id="paythen-product-detail">
                    <div class="popup-box">
                        <div class="product-detail-data">                   
                            <div id="paythenModal" class="paythen-custom-modal paythen-modal-main">
                              <div class="modal-content">
                                <span class="close">&times;</span>
                                <div class="popup-header">
                                  <h3>How it works</h3>
                                  <p>It’s easy to pay with a payment plan. Just choose this option when you check out and enter your payment information to begin your plan.</p>
                                  <p>'.$gateway->get_option('paythen_information_text').'</p>
                                </div>
                                <div class="center-four-icon">
                                  <ul>
                                    <li>
                                      <div class="top-img">
                                        <img src="https://paythen.parts/woocommerce/plugin/images/paythen-shopping-bag-icon.svg">
                                      </div>
                                      <h3>Choose the payment plan option at checkout</h3>
                                      <p>You’ll be redirected to the payment plan page</p>
                                    </li>
                                    <li>
                                      <div class="top-img">
                                        <img src="https://paythen.parts/woocommerce/plugin/images/paythen-receipt-icon.svg">
                                      </div>
                                      <h3>Enter your payment information to start</h3>
                                      <p>Your order is confirmed once you complete this step</p>
                                    </li>
                                    <li>
                                      <div class="top-img">
                                        <img src="https://paythen.parts/woocommerce/plugin/images/paythen-email-icon.svg">
                                      </div>
                                      <h3>You’ll get an email with your payment plan dates</h3>
                                      <p>This will include a link you can use to easily manage your plan</p>
                                    </li>
                                    <li>
                                      <div class="top-img">
                                        <img src="https://paythen.parts/woocommerce/plugin/images/paythen-calendar-recurring-icon.svg">
                                      </div>
                                      <h3>Scheduled payments are automatically charged</h3>
                                      <p>You’ll get an email reminder two days before each payment</p>
                                    </li>
                                  </ul>
                                </div>
                                <div class="bottom-text">Your data is processed securely using SSL and AES-256 encryption. We use <a target="_blank" href="https://paythen.co?utm_source=woocommerce&utm_medium=ecommerce&utm_campaign=powered-by-footer&utm_content=modal-product-page">Paythen</a> to manage and process payments. </div>
                              </div>
                            </div>
                        </div>
                    </div>
                </div>'.'';
            }
        }else{
            $custom_text = '<div class="paythen-modal-main"><a href="javascript:void(0)" class="paythen-modal"><b>Easy payment plan available.</b> Choose this option at checkout <span class="information-icon"></span></a></div>';
                echo $custom_text.'<div class="pop-upbox continue-payment-popup" id="paythen-product-detail">
                    <div class="popup-box">
                        <div class="product-detail-data">                   
                            <div id="paythenModal" class="paythen-custom-modal paythen-modal-main">
                              <div class="modal-content">
                                <span class="close">&times;</span>
                                <div class="popup-header">
                                  <h3>How it works</h3>
                                  <p>It’s easy to pay with a payment plan. Just choose this option when you check out and enter your payment information to begin your plan.</p>
                                  <p>'.$gateway->get_option('paythen_information_text').'</p>
                                </div>
                                <div class="center-four-icon">
                                  <ul>
                                    <li>
                                      <div class="top-img">
                                        <img src="https://paythen.parts/woocommerce/plugin/images/paythen-shopping-bag-icon.svg">
                                      </div>
                                      <h3>Choose the payment plan option at checkout</h3>
                                      <p>You’ll be redirected to the payment plan page</p>
                                    </li>
                                    <li>
                                      <div class="top-img">
                                        <img src="https://paythen.parts/woocommerce/plugin/images/paythen-receipt-icon.svg">
                                      </div>
                                      <h3>Enter your payment information to start</h3>
                                      <p>Your order is confirmed once you complete this step</p>
                                    </li>
                                    <li>
                                      <div class="top-img">
                                        <img src="https://paythen.parts/woocommerce/plugin/images/paythen-email-icon.svg">
                                      </div>
                                      <h3>You’ll get an email with your payment plan dates</h3>
                                      <p>This will include a link you can use to easily manage your plan</p>
                                    </li>
                                    <li>
                                      <div class="top-img">
                                        <img src="https://paythen.parts/woocommerce/plugin/images/paythen-calendar-recurring-icon.svg">
                                      </div>
                                      <h3>Scheduled payments are automatically charged</h3>
                                      <p>You’ll get an email reminder two days before each payment</p>
                                    </li>
                                  </ul>
                                </div>
                                <div class="bottom-text">Your data is processed securely using SSL and AES-256 encryption. We use <a target="_blank" href="https://paythen.co?utm_source=woocommerce&utm_medium=ecommerce&utm_campaign=powered-by-footer&utm_content=modal-product-page">Paythen</a> to manage and process payments. </div>
                              </div>
                            </div>
                        </div>
                    </div>
                </div>'.'';
        }
    }
}