<?php
/**
* Plugin Name: Paythen Payment Plans for WooCommerce
* License: GPLv2 or later
* Plugin URI: https://paythen.co/woocommerce-plugin/visit-plugin-site/
* Version: 0.9.4
* Description: Easily create and offer flexible payment plans in your WooCommerce store. Requires a Paythen account to use. Start with a free 7 day trial at <a href='https://paythen.co'>paythen.co</a>. To manage settings for this plugin, please go to WooCommerce > Settings > Payments.
* Author: Paythen
* Author URI: https://paythen.co/woocommerce-plugin/author-link/ 
* Requires at least: 6
* Tested up to: 6.7.2
* WC tested up to: 9.7.1
* WC requires at least: 8.2
*/

if ( ! defined( 'ABSPATH' ) ) exit;

define('PAYTHEN_PATH', untrailingslashit(plugin_dir_path( __FILE__ )) );
define('PAYTHEN_PATH_INNER', plugin_dir_path( __FILE__ ));

include_once( ABSPATH . 'wp-admin/includes/plugin.php' );

// make sure woocommerce exists
if (is_plugin_active( 'woocommerce/woocommerce.php' )) {
    add_action('plugins_loaded', 'woocommerce_paythen_init');
}

add_action( 'before_woocommerce_init', function() {
  if ( class_exists( \Automattic\WooCommerce\Utilities\FeaturesUtil::class ) ) {
    \Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility( 'custom_order_tables', __FILE__, true );
  }
} );

function woocommerce_paythen_init() {

    if ( ! class_exists('WC_Payment_Gateway'))  return;

    include_once PAYTHEN_PATH . "/classes/paythen/payment-gateway.php";

    include_once PAYTHEN_PATH . "/inc/notification-handler.php";

    include_once PAYTHEN_PATH . "/inc/gateway.php";

    if (is_admin()) {
      include_once PAYTHEN_PATH . "/classes/paythen/paythen-admin.php";
      $paythenAdmin = new Paythen_Admin();
    }
}

function paythen_settings_link($links) { 
  $settings_link = '<a href="admin.php?page=wc-settings&tab=checkout&section=paythen">Settings</a>'; 
  array_unshift($links, $settings_link); 
  return $links; 
}
$plugin = plugin_basename(__FILE__); 
add_filter("plugin_action_links_$plugin", 'paythen_settings_link' );

function add_paythen_scripts() {
  wp_enqueue_style( 'paythen-style', plugin_dir_url( __FILE__ ) . 'classes/css/paythen.css', array(), '1.1', 'all');
}
add_action( 'wp_enqueue_scripts', 'add_paythen_scripts' );

function paythen_admin_script() {
    if(is_admin()){
      wp_enqueue_script('paythen-admin-js', plugin_dir_url( __FILE__ ) . 'classes/js/admin.js', array('jquery'));
      wp_enqueue_style( 'paythen-admin-style', plugin_dir_url( __FILE__ ) . 'classes/css/paythen-admin.css', array(), '1.1', 'all');
    }   
    wp_enqueue_script( 'paythen-custom-js', plugin_dir_url( __FILE__ ) . 'classes/js/paythen-custom.js', array('jquery'));
}
add_action('init', 'paythen_admin_script');