<?php

use Automattic\WooCommerce\Blocks\Payments\Integrations\AbstractPaymentMethodType;

final class Paythen_Custom_Gateway_Blocks extends AbstractPaymentMethodType {

    private $gateway;
    protected $name = 'paythen_custom_gateway'; // your payment gateway name

    public function initialize() {
        $this->settings = get_option('woocommerce_paythen_custom_gateway_settings', []);
        $this->gateway = new WC_Gateway_Paythen();
    }

    public function is_active() {
        return $this->gateway->is_available();
    }

    public function get_payment_method_script_handles() {
        wp_register_script(
            'paythen_custom_gateway-blocks-integration',
            plugin_dir_url(__FILE__) . 'checkout.js',
            [
                'wc-blocks-registry',
                'wc-settings',
                'wp-element',
                'wp-html-entities',
                'wp-i18n',
                'jquery' // Add jQuery as a dependency
            ],
            null,
            true
        );
        if (function_exists('wp_set_script_translations')) {
            wp_set_script_translations('paythen_custom_gateway-blocks-integration');
        }

        // Get min/max upfront amount values
        $amount_upfront_type = $this->gateway->get_option('amount_upfront_type', 'fixed');
        $min_upfront_value = (int) $this->gateway->get_option('min_amount_one_upfront', 0);
        $max_upfront_value = (int) $this->gateway->get_option('max_amount_one_upfront', 0);
        $cartTotal = WC()->cart ? WC()->cart->get_total(null) : 0;
        $currencySign = get_woocommerce_currency_symbol();

        $min_upfront_amount = null;
        $max_upfront_amount = null;

        if ($amount_upfront_type === 'fixed' && $min_upfront_value > 0) {
            $min_upfront_amount = $min_upfront_value;
        } elseif ($amount_upfront_type === 'percentage' && $min_upfront_value > 0) {
            $min_upfront_amount = ceil(($cartTotal * $min_upfront_value) / 100);
        }

        if ($amount_upfront_type === 'fixed' && $max_upfront_value > 0) {
            $max_upfront_amount = $max_upfront_value;
        } elseif ($amount_upfront_type === 'percentage' && $max_upfront_value > 0) {
            $max_upfront_amount = ceil(($cartTotal * $max_upfront_value) / 100);
        }

        // Localize script with settings
        $settings = [
            'title' => $this->gateway->get_option('title'),
            'description' => $this->gateway->get_option('description'),
            'numberInstallments' => $this->gateway->get_option('number-installments', 'no'),
            'separatePayment' => $this->gateway->get_option('separate-payment-option', 'no'),
            'minInstallment' => $this->gateway->get_option('min_installment', 1),
            'maxInstallment' => $this->gateway->get_option('max_installment'),
            'paymentOptions' => [
                ['title' => $this->gateway->get_option('payment-title-one'), 'url' => $this->gateway->get_option('payment-url-one')],
                ['title' => $this->gateway->get_option('payment-title-two'), 'url' => $this->gateway->get_option('payment-url-two')],
                ['title' => $this->gateway->get_option('payment-title-three'), 'url' => $this->gateway->get_option('payment-url-three')],
            ],
            'upfrontAmount' => $this->gateway->get_option('upfront-payment-amount-option','no'),
            'minUpfrontAmount' => $min_upfront_amount,
            'maxUpfrontAmount' => $max_upfront_amount,
            'remainingPaymentDays' => $this->gateway->get_option('remaining_payment_days_upfront'),
            'carttotalVal'=> $cartTotal,
            'currency_format_symbol' => $currencySign,
            'ajaxurl' => admin_url('admin-ajax.php') // Add the AJAX URL
        ];

        wp_localize_script('paythen_custom_gateway-blocks-integration', 'paythen_custom_gateway_data', $settings);
        wp_localize_script('paythen_custom_gateway-blocks-integration', 'paythenAjax', ['ajaxurl' => admin_url('admin-ajax.php')]);

        return ['paythen_custom_gateway-blocks-integration'];
    }

    public function get_payment_method_data() {
        return [
            'title' => $this->gateway->title,
            'description' => $this->gateway->description,
            'minUpfrontAmount' => $this->gateway->get_option('min_upfront_amount', 0),
            'maxUpfrontAmount' => $this->gateway->get_option('max_upfront_amount', 0),
        ];
    }

}

?>
